﻿using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.GUI;

namespace WPF.PresentationLayer.UC115.ViewModels
{
    public abstract class ViewModelBase : NotifyPropertyChanged
    {
        #region Properties

        private string formText;
        public string FormText
        {
            get
            {
                return formText;
            }
            set
            {
                formText = value;
                if (VbecsBaseForm != null)
                {
                    VbecsBaseForm.Text = FormText;
                }
            }
        }

        private string logoHeaderText;
        public string LogoHeaderText
        {
            get
            {
                return logoHeaderText;
            }
            set
            {
                logoHeaderText = value;
                if (VbecsBaseForm != null)
                {
                    VbecsBaseForm.SetVbecsLogoTitle(LogoHeaderText);
                }
            }
        }

        private bool canMaximize;
        public bool CanMaximize
        {
            get
            {
                return canMaximize;
            }
            set
            {
                canMaximize = value;
                if (VbecsBaseForm != null)
                {
                    VbecsBaseForm.MaximizeBox = canMaximize;
                }
            }
        }

        private bool canMinimize;
        public bool CanMinimize
        {
            get
            {
                return canMinimize;
            }
            set
            {
                canMinimize = value;
                if (VbecsBaseForm != null)
                {
                    VbecsBaseForm.MinimizeBox = canMinimize;
                }
            }
        }

        private VbecsBaseForm vbecsBaseForm;
        public VbecsBaseForm VbecsBaseForm
        {
            get
            {
                return vbecsBaseForm;
            }
            private set
            {
                vbecsBaseForm = value;
                RaisePropertyChanged(() => VbecsBaseForm);
            }
        }
        #endregion

        public ViewModelBase()
        {
            CanMaximize = true;
            CanMinimize = true;
        }

        /// <summary>
        /// Locking Descriptor 
        /// </summary>
        private LockFunctions lockFunction = LockFunctions.NA;
        public LockFunctions LockFunction
        {
            get
            {
                return lockFunction;
            }
            set
            {
                lockFunction = value;
                if (VbecsBaseForm != null)
                {
                    VbecsBaseForm.LockController.LockFunction = lockFunction;
                }
            }
        }

        public void SetVbecsBaseForm(VbecsBaseForm vbecsBaseForm, bool setFormProperties)
        {
            VbecsBaseForm = vbecsBaseForm;

            if (setFormProperties &&
                vbecsBaseForm != null)
            {
                vbecsBaseForm.MaximizeBox = CanMaximize;
                vbecsBaseForm.MinimizeBox = CanMinimize;
                vbecsBaseForm.Text = FormText;
                vbecsBaseForm.SetVbecsLogoTitle(LogoHeaderText);
                vbecsBaseForm.LockController.LockFunction = LockFunction;
            }
        }
    }
}
